/*--- CRCCCITT.C  ------------------------- Listing 10-6 -------
 * Compute CCITT-CRC using a look-up table
 * Usage:   crcccitt filename
 *
 * Based on a similar program by Nigel Cort in C Gazette 5.1
 * (Autumn 1990).
 *------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>

#include "ccitt.tbl"  /* generated by mkccitt.c (Listing 10-5) */

int main ( int argc, char * argv[] )
{
   FILE *fin;            /* file we're reading into buffer */
   char *buffer;         /* buffer we're working on        */
   size_t i, j;          /* counters of bytes in buff      */
   unsigned short crc;   /* the CRC value being computed   */

   if ( argc < 2 )
   {
      fprintf ( stderr, "Error! Must specify filename.\n" );
      return ( EXIT_FAILURE );
   }

   if (( fin = fopen ( argv[1], "rb" )) == NULL )
   {
      fprintf ( stderr, "Cannot open %s\n", argv[1] );
      return ( EXIT_FAILURE );
   }

   /*--------------------------------------------------
    * Set up a very large input buffer of 32K bytes.
    * This program does no good if it doesn't fly!
    *-------------------------------------------------*/

   if (( buffer = (char *) malloc ( 32766 )) == NULL )
   {
      fprintf ( stderr, "Out of memory\n" );
      return ( EXIT_FAILURE );
   }

   crc = 0;

   for (;;)
   {
      i = fread ( buffer, 1, 32766, fin );
      if ( i == 0 )
      {
         if ( feof ( fin ))  /* we're done, so show results */
         {
            printf ( "CRC-CCITT for %s is %04X\n",
                                            argv[1], crc );
            return ( EXIT_SUCCESS );
         }
         else         /* read another 32K of file */
            continue;
      }

      for ( j = 0 ; j < i; j ++ )  /* loop through the buffer */
        crc =
            (crc << 8) ^ ccitt_table [ (crc >> 8) ^ buffer [j] ];
   }
}
