/*--- crc32.c ----------------------------- Listing 10-9 -------
 * Compute CRC-32 using a lookup table
 * Usage:  crc32 filename
 *------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>

#include "crc32.tbl"  /* generated by mkcrc32.c (Listing 10-8) */

int main ( int argc, char * argv[] )
{
   FILE *fin;             /* file we're reading into buffer */
   unsigned char *buffer; /* buffer we're working on        */
   size_t i, j;           /* counters of bytes in buff      */
   int k;                 /* generic integer                */
   unsigned long crc;     /* the CRC value being computed   */

   if ( argc < 2 )
   {
      fprintf ( stderr, "Error! Must specify filename.\n" );
      return ( EXIT_FAILURE );
   }

   if (( fin = fopen ( argv[1], "rb" )) == NULL )
   {
      fprintf ( stderr, "Cannot open %s\n", argv[1] );
      return ( EXIT_FAILURE );
   }

   /*--------------------------------------------------
    * Set up a very large input buffer of 32K bytes.
    * This program does no good if it doesn't fly!
    *-------------------------------------------------*/

   if (( buffer = (unsigned char *) malloc ( 32766 )) == NULL )
   {
      fprintf ( stderr, "Out of memory\n" );
      return ( EXIT_FAILURE );
   }

   /* preconditioning sets crc to an initial nonzero value */

   crc = 0xFFFFFFFF;

   for (;;)
   {
      i = fread ( buffer, 1, 32766, fin );
      if ( i == 0 )
      {
         if ( feof ( fin ))  /* we're done, so show results */
         {
            /* postconditioning inverts the bits in CRC */

            crc = ~crc;

            /* now print the result */

            printf ( "CRC-32 for %s is %08lX\n",
                                            argv[1], crc );
            return ( EXIT_SUCCESS );
         }
         else         /* read another 32K of file */
            continue;
      }

      for ( j = 0; j < i; j ++ )  /* loop through the buffer */
      {
         k = ( crc ^ buffer[j] ) & 0x000000FFL;
         crc = (( crc >> 8 ) & 0x00FFFFFFL ) ^ crc32_table[k];
      }
   }
}
